using System;
using System.Web;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
	public partial class WKF_CASEDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public WKF_CASEDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public WKF_CASE GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ID)
        {
            WKF_CASE objReturn = null;

            SqlConnection sConn = null;
            SqlCommand sCmd = null;
            SqlDataAdapter sAdapter = null;
            DataSet objTemp = null;

            try
            {
                sConn = new SqlConnection(SqlConnectionString);

                sConn.Open();

                sCmd = new SqlCommand("CRS.usp_WKF_CASE_getitem", sConn);
                sCmd.CommandTimeout = SqlCommandTimeout;
                sCmd.CommandType = CommandType.StoredProcedure;
                sCmd.Parameters.AddWithValue("@CURRENT_USER", CURRENT_USER);
                sCmd.Parameters.AddWithValue("@CURRENT_REGISTRY_ID", CURRENT_REGISTRY_ID);
                sCmd.Parameters.AddWithValue("@WKF_CASE_ID", WKF_CASE_ID);

                objTemp = new DataSet();
                sAdapter = new SqlDataAdapter(sCmd);

                LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                sAdapter.Fill(objTemp);
                LogManager.LogTiming(logDetails);
                CheckDataSet(objTemp);

                if (objTemp != null && objTemp.Tables.Count > 0 && objTemp.Tables[0].Rows.Count > 0)
                {
                    objReturn = ParseReader(objTemp.Tables[0].Rows[0]);
                }

                sConn.Close();
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }
            finally
            {
                if (sAdapter != null)
                {
                    sAdapter.Dispose();
                    sAdapter = null;
                }
                if (sCmd != null)
                {
                    sCmd.Dispose();
                    sCmd = null;
                }
                if (sConn != null)
                {
                    if (sConn.State != ConnectionState.Closed) { sConn.Close(); }
                    sConn.Dispose();
                    sConn = null;
                }
            }

            return objReturn;
        }

        public List<WKF_CASE> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<WKF_CASE> objReturn = null;

            SqlConnection sConn = null;
            SqlCommand sCmd = null;
            SqlDataAdapter sAdapter = null;
            DataSet objTemp = null;

            try
            {
                sConn = new SqlConnection(SqlConnectionString);

                sConn.Open();

                sCmd = new SqlCommand("CRS.usp_WKF_CASE_getitems", sConn);
                sCmd.CommandTimeout = SqlCommandTimeout;
                sCmd.CommandType = CommandType.StoredProcedure;
                sCmd.Parameters.AddWithValue("@CURRENT_USER", CURRENT_USER);
                sCmd.Parameters.AddWithValue("@CURRENT_REGISTRY_ID", CURRENT_REGISTRY_ID);

                objTemp = new DataSet();
                sAdapter = new SqlDataAdapter(sCmd);

                LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                sAdapter.Fill(objTemp);
                LogManager.LogTiming(logDetails);
                CheckDataSet(objTemp);

                if (objTemp != null && objTemp.Tables.Count > 0 && objTemp.Tables[0].Rows.Count > 0)
                {
                    var myData = objTemp.Tables[0].AsEnumerable().Select(r => ParseReader(r));
                    if (myData != null)
                    {
                        objReturn = myData.ToList<WKF_CASE>();
                    }
                }

                sConn.Close();
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }
            finally
            {
                if (sAdapter != null)
                {
                    sAdapter.Dispose();
                    sAdapter = null;
                }
                if (sCmd != null)
                {
                    sCmd.Dispose();
                    sCmd = null;
                }
                if (sConn != null)
                {
                    if (sConn.State != ConnectionState.Closed) { sConn.Close(); }
                    sConn.Dispose();
                    sConn = null;
                }
            }

            return objReturn;
        }

        public Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, WKF_CASE objSave)
        {
            Int32 objReturn = 0;

            SqlConnection sConn = null;
            SqlCommand sCmd = null;
            SqlParameter p = null;
            SqlDataAdapter sAdapter = null;
            DataSet objTemp = null;

            try
            {
                sConn = new SqlConnection(SqlConnectionString);

                sConn.Open();

                sCmd = new SqlCommand("CRS.usp_WKF_CASE_save", sConn);
                sCmd.CommandTimeout = SqlCommandTimeout;
                sCmd.CommandType = CommandType.StoredProcedure;
                sCmd.Parameters.AddWithValue("@CURRENT_USER", CURRENT_USER);
                sCmd.Parameters.AddWithValue("@CURRENT_REGISTRY_ID", CURRENT_REGISTRY_ID);

                p = new SqlParameter("@CASE_DUE_DATE", SqlDbType.DateTime, 8);
                p.Precision = 23;
                p.Scale = 3;
                AddParameter(ref sCmd, ref p, objSave.CASE_DUE_DATE);
                p = new SqlParameter("@CASE_NUMBER", SqlDbType.VarChar, 30);
                p.Precision = 0;
                p.Scale = 0;
                AddParameter(ref sCmd, ref p, objSave.CASE_NUMBER);
                p = new SqlParameter("@CASE_START_DATE", SqlDbType.DateTime, 8);
                p.Precision = 23;
                p.Scale = 3;
                AddParameter(ref sCmd, ref p, objSave.CASE_START_DATE);
                p = new SqlParameter("@CREATED", SqlDbType.DateTime, 8);
                p.Precision = 23;
                p.Scale = 3;
                AddParameter(ref sCmd, ref p, objSave.CREATED);
                p = new SqlParameter("@CREATEDBY", SqlDbType.VarChar, 30);
                p.Precision = 0;
                p.Scale = 0;
                AddParameter(ref sCmd, ref p, objSave.CREATEDBY);
                p = new SqlParameter("@PARENT_CASE_ID", SqlDbType.Int, 4);
                p.Precision = 10;
                p.Scale = 0;
                AddParameter(ref sCmd, ref p, objSave.PARENT_CASE_ID);
                p = new SqlParameter("@PATIENT_ID", SqlDbType.Int, 4);
                p.Precision = 10;
                p.Scale = 0;
                AddParameter(ref sCmd, ref p, objSave.PATIENT_ID);
                p = new SqlParameter("@REFERRAL_ID", SqlDbType.Int, 4);
                p.Precision = 10;
                p.Scale = 0;
                AddParameter(ref sCmd, ref p, objSave.REFERRAL_ID);
                p = new SqlParameter("@STD_WKFCASETYPE_ID", SqlDbType.Int, 4);
                p.Precision = 10;
                p.Scale = 0;
                AddParameter(ref sCmd, ref p, objSave.STD_WKFCASETYPE_ID);
                p = new SqlParameter("@UPDATED", SqlDbType.DateTime, 8);
                p.Precision = 23;
                p.Scale = 3;
                AddParameter(ref sCmd, ref p, objSave.UPDATED);
                p = new SqlParameter("@UPDATEDBY", SqlDbType.VarChar, 30);
                p.Precision = 0;
                p.Scale = 0;
                AddParameter(ref sCmd, ref p, objSave.UPDATEDBY);
                p = new SqlParameter("@WKF_CASE_ID", SqlDbType.Int, 4);
                p.Direction = ParameterDirection.InputOutput;
                p.Precision = 10;
                p.Scale = 0;
                AddParameter(ref sCmd, ref p, objSave.WKF_CASE_ID);
                p = new SqlParameter("@STD_WKFCASESTS_ID", SqlDbType.Int, 4);
                p.Precision = 10;
                p.Scale = 0;
                AddParameter(ref sCmd, ref p, objSave.STD_WKFCASESTS_ID);

                objTemp = new DataSet();
                sAdapter = new SqlDataAdapter(sCmd);

                LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                //int cnt = sCmd.ExecuteNonQuery();
                sAdapter.Fill(objTemp);
                LogManager.LogTiming(logDetails);
                CheckDataSet(objTemp);

                objReturn = (Int32)sCmd.Parameters["@WKF_CASE_ID"].Value;

                sConn.Close();
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }
            finally
            {
                if (sAdapter != null)
                {
                    sAdapter.Dispose();
                    sAdapter = null;
                }
                if (sCmd != null)
                {
                    sCmd.Dispose();
                    sCmd = null;
                }
                if (sConn != null)
                {
                    if (sConn.State != ConnectionState.Closed) { sConn.Close(); }
                    sConn.Dispose();
                    sConn = null;
                }
            }

            return objReturn;
        }

        public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ID)
        {
            Boolean objReturn = false;

            SqlConnection sConn = null;
            SqlCommand sCmd = null;

            try
            {
                sConn = new SqlConnection(SqlConnectionString);

                sConn.Open();

                sCmd = new SqlCommand("CRS.usp_WKF_CASE_delete", sConn);
                sCmd.CommandTimeout = SqlCommandTimeout;
                sCmd.CommandType = CommandType.StoredProcedure;
                sCmd.Parameters.AddWithValue("@CURRENT_USER", CURRENT_USER);
                sCmd.Parameters.AddWithValue("@CURRENT_REGISTRY_ID", CURRENT_REGISTRY_ID);
                sCmd.Parameters.AddWithValue("@WKF_CASE_ID", WKF_CASE_ID);
                LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                int cnt = sCmd.ExecuteNonQuery();
                LogManager.LogTiming(logDetails);

                objReturn = true;

                sConn.Close();
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }
            finally
            {
                if (sCmd != null)
                {
                    sCmd.Dispose();
                    sCmd = null;
                }
                if (sConn != null)
                {
                    if (sConn.State != ConnectionState.Closed) { sConn.Close(); }
                    sConn.Dispose();
                    sConn = null;
                }
            }

            return objReturn;
        }

        public WKF_CASE ParseReader(DataRow row)
        {
            WKF_CASE objReturn = new WKF_CASE
            {
                CASE_DUE_DATE = (DateTime?)GetNullableObject(row.Field<object>("CASE_DUE_DATE")),
                CASE_NUMBER = (string)GetNullableObject(row.Field<object>("CASE_NUMBER")),
                CASE_START_DATE = (DateTime?)GetNullableObject(row.Field<object>("CASE_START_DATE")),
                CREATED = (DateTime)GetNullableObject(row.Field<object>("CREATED")),
                CREATEDBY = (string)GetNullableObject(row.Field<object>("CREATEDBY")),
                PARENT_CASE_ID = (Int32?)GetNullableObject(row.Field<object>("PARENT_CASE_ID")),
                PATIENT_ID = (Int32)GetNullableObject(row.Field<object>("PATIENT_ID")),
                REFERRAL_ID = (Int32?)GetNullableObject(row.Field<object>("REFERRAL_ID")),
                STD_WKFCASETYPE_ID = (Int32)GetNullableObject(row.Field<object>("STD_WKFCASETYPE_ID")),
                UPDATED = (DateTime)GetNullableObject(row.Field<object>("UPDATED")),
                UPDATEDBY = (string)GetNullableObject(row.Field<object>("UPDATEDBY")),
                WKF_CASE_ID = (Int32)GetNullableObject(row.Field<object>("WKF_CASE_ID")),
                STD_WKFCASESTS_ID = (Int32)GetNullableObject(row.Field<object>("STD_WKFCASESTS_ID"))
            };

            return objReturn;
        }

        public WKF_CASE ParseReaderCustom(DataRow row)
        {
            WKF_CASE objReturn = new WKF_CASE
            {
                CASE_DUE_DATE = (DateTime?)GetNullableObject(row.Field<object>("WKF_CASE_CASE_DUE_DATE")),
                CASE_NUMBER = (string)GetNullableObject(row.Field<object>("WKF_CASE_CASE_NUMBER")),
                CASE_START_DATE = (DateTime?)GetNullableObject(row.Field<object>("WKF_CASE_CASE_START_DATE")),
                CREATED = (DateTime)GetNullableObject(row.Field<object>("WKF_CASE_CREATED")),
                CREATEDBY = (string)GetNullableObject(row.Field<object>("WKF_CASE_CREATEDBY")),
                PARENT_CASE_ID = (Int32?)GetNullableObject(row.Field<object>("WKF_CASE_PARENT_CASE_ID")),
                PATIENT_ID = (Int32)GetNullableObject(row.Field<object>("WKF_CASE_PATIENT_ID")),
                REFERRAL_ID = (Int32?)GetNullableObject(row.Field<object>("WKF_CASE_REFERRAL_ID")),
                STD_WKFCASETYPE_ID = (Int32)GetNullableObject(row.Field<object>("WKF_CASE_STD_WKFCASETYPE_ID")),
                UPDATED = (DateTime)GetNullableObject(row.Field<object>("WKF_CASE_UPDATED")),
                UPDATEDBY = (string)GetNullableObject(row.Field<object>("WKF_CASE_UPDATEDBY")),
                WKF_CASE_ID = (Int32)GetNullableObject(row.Field<object>("WKF_CASE_WKF_CASE_ID")),
                STD_WKFCASESTS_ID = (Int32)GetNullableObject(row.Field<object>("WKF_CASE_STD_WKFCASESTS_ID"))
            };

            return objReturn;
        }

        public List<WKF_CASE> GetItemsByRegistry(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<WKF_CASE> objReturn = null;

            SqlConnection sConn = null;
            SqlCommand sCmd = null;
            SqlDataAdapter sAdapter = null;
            DataSet objTemp = null;

            try
            {
                sConn = new SqlConnection(SqlConnectionString);

                sConn.Open();

                sCmd = new SqlCommand("CRS.usp_WKF_CASE_getitemsByRegistry", sConn);
                sCmd.CommandTimeout = SqlCommandTimeout;
                sCmd.CommandType = CommandType.StoredProcedure;
                sCmd.Parameters.AddWithValue("@CURRENT_USER", CURRENT_USER);
                sCmd.Parameters.AddWithValue("@CURRENT_REGISTRY_ID", CURRENT_REGISTRY_ID);

                objTemp = new DataSet();
                sAdapter = new SqlDataAdapter(sCmd);

                LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                sAdapter.Fill(objTemp);
                LogManager.LogTiming(logDetails);
                CheckDataSet(objTemp);

                if (objTemp != null && objTemp.Tables.Count > 0 && objTemp.Tables[0].Rows.Count > 0)
                {
                    var myData = objTemp.Tables[0].AsEnumerable().Select(r => ParseReaderComplete(r));
                    if (myData != null)
                    {
                        objReturn = myData.ToList<WKF_CASE>();
                    }
                }

                sConn.Close();
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }
            finally
            {
                if (sAdapter != null)
                {
                    sAdapter.Dispose();
                    sAdapter = null;
                }
                if (sCmd != null)
                {
                    sCmd.Dispose();
                    sCmd = null;
                }
                if (sConn != null)
                {
                    if (sConn.State != ConnectionState.Closed) { sConn.Close(); }
                    sConn.Dispose();
                    sConn = null;
                }
            }

            return objReturn;
        }

        public Boolean UpdateStatus(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ID, Int32 STD_WKFCASESTS_ID)
        {
            Boolean objReturn = false;
            WKF_CASEDB objDB = new WKF_CASEDB();

            SqlConnection sConn = null;
            SqlCommand sCmd = null;

            try
            {
                sConn = new SqlConnection(SqlConnectionString);

                sConn.Open();

                sCmd = new SqlCommand("CRS.usp_WKF_CASE_updateStatus", sConn);
                sCmd.CommandTimeout = SqlCommandTimeout;
                sCmd.CommandType = CommandType.StoredProcedure;
                sCmd.Parameters.AddWithValue("@CURRENT_USER", CURRENT_USER);
                sCmd.Parameters.AddWithValue("@CURRENT_REGISTRY_ID", CURRENT_REGISTRY_ID);
                sCmd.Parameters.AddWithValue("@WKF_CASE_ID", WKF_CASE_ID);
                sCmd.Parameters.AddWithValue("@STD_WKFCASESTS_ID", STD_WKFCASESTS_ID);

                LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                sCmd.ExecuteNonQuery();
                LogManager.LogTiming(logDetails);

                objReturn = true;

                sConn.Close();
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }
            finally
            {
                if (sCmd != null)
                {
                    sCmd.Dispose();
                    sCmd = null;
                }
                if (sConn != null)
                {
                    if (sConn.State != ConnectionState.Closed) { sConn.Close(); }
                    sConn.Dispose();
                    sConn = null;
                }
            }

            return objReturn;
        }

        public WKF_CASE ParseReaderComplete(DataRow row)
        {
            WKF_CASE objReturn = ParseReaderCustom(row);

            if (objReturn != null)
            {
                if (objReturn.PATIENT_ID > 0)
                {
                    PATIENTDB pATIENTDB = new PATIENTDB();
                    objReturn.PATIENT = pATIENTDB.ParseReaderCustom(row);
                }

                if (objReturn.STD_WKFCASETYPE_ID > 0)
                {
                    STD_WKFCASETYPEDB sTD_WKFCASETYPEDB = new STD_WKFCASETYPEDB();
                    objReturn.STD_WKFCASETYPE = sTD_WKFCASETYPEDB.ParseReaderCustom(row);
                }

                if (objReturn.STD_WKFCASESTS_ID > 0)
                {
                    STD_WKFCASESTSDB sTD_WKFCASESTSDB = new STD_WKFCASESTSDB();
                    objReturn.STD_WKFCASESTS = sTD_WKFCASESTSDB.ParseReaderCustom(row);
                }

                if (objReturn.REFERRAL_ID > 0)
                {
                    REFERRALDB rEFERRALDB = new REFERRALDB();
                    objReturn.REFERRAL = rEFERRALDB.ParseReaderCustom(row);
                }
            }

            return objReturn;
        }

		#endregion
	}
}
